<?php
session_start();
include 'conexao.php';

$mensagem = '';

// Função para obter os anos únicos diretamente da tabela `turmas`
function obterAnosLetivos($conn) {
    $anos = [];
    $result = $conn->query("SELECT DISTINCT ano FROM turmas ORDER BY ano DESC");
    while ($row = $result->fetch_assoc()) {
        $anos[] = $row['ano'];
    }
    return $anos;
}

$anos_letivos = obterAnosLetivos($conn);

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['salvar_aluno'])) {
    $nome = trim($_POST["nome"]);
    $idade = intval($_POST["idade"]);
    $genero = $_POST["genero"];
    $ano_letivo = $_POST['ano_letivo'] ?? null;
    $turma_id = $_POST['turma_id'] ?? null;

    $numero_ordem = $_POST['numero_ordem'] ?? null;
    $naturalidade = $_POST['naturalidade'] ?? null;
    $provincia = $_POST['provincia'] ?? null;
    $municipio = $_POST['municipio'] ?? null;
    $nome_pai = $_POST['nome_pai'] ?? null;
    $nome_mae = $_POST['nome_mae'] ?? null;
    $nascimento = $_POST['nascimento'] ?? null;
    $bi = $_POST['bi'] ?? null;
    $bi_emissao_data = $_POST['bi_emissao_data'] ?? null;
    $bi_emissao_local = $_POST['bi_emissao_local'] ?? null;

$aluno_id = $_POST['aluno_id_hidden'] ?? null;


if ($aluno_id) {
    // Atualiza aluno existente
    $stmt = $conn->prepare("UPDATE alunos SET nome=?, idade=?, genero=?, ano_letivo=?, turma_id=?, numero_ordem=?, naturalidade=?, provincia=?, municipio=?, nome_pai=?, nome_mae=?, nascimento=?, bi=?, bi_emissao_data=?, bi_emissao_local=? WHERE id=?");
    $stmt->bind_param("sississssssssssi", $nome, $idade, $genero, $ano_letivo, $turma_id, $numero_ordem, $naturalidade, $provincia, $municipio, $nome_pai, $nome_mae, $nascimento, $bi, $bi_emissao_data, $bi_emissao_local, $aluno_id);

    if ($stmt->execute()) {
        $mensagem = "<p style='color: green;'>✅ Dados do aluno atualizados com sucesso!</p>";
    } else {
        $mensagem = "<p style='color: red;'>❌ Erro ao atualizar aluno!</p>";
    }
} else {
    // Insere novo aluno
    $stmt = $conn->prepare("INSERT INTO alunos (nome, idade, genero, ano_letivo, turma_id, numero_ordem, naturalidade, provincia, municipio, nome_pai, nome_mae, nascimento, bi, bi_emissao_data, bi_emissao_local)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sississssssssss", $nome, $idade, $genero, $ano_letivo, $turma_id, $numero_ordem, $naturalidade, $provincia, $municipio, $nome_pai, $nome_mae, $nascimento, $bi, $bi_emissao_data, $bi_emissao_local);

    if ($stmt->execute()) {
        $mensagem = "<p style='color: green;'>✅ Aluno cadastrado com sucesso!</p>";
    } else {
        $mensagem = "<p style='color: red;'>❌ Erro ao cadastrar aluno!</p>";
    }
}

}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Cadastrar Aluno</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="estilo_painel.css">
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background: #e9ecef;
        }

        .barra-superior {
            background-color: #004080;
            color: white;
            padding: 15px;
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1000;
        }

        .barra-lateral {
            width: 240px;
            position: fixed;
            top: 60px;
            left: 0;
            height: 100%;
            background-color: #001f3f;
            padding-top: 20px;
        }

        .barra-lateral a {
            display: block;
            padding: 15px;
            color: white;
            text-decoration: none;
        }

        .barra-lateral a:hover {
            background-color: #0059b3;
        }

        .conteudo {
            margin-left: 260px;
            margin-top: 80px;
            padding: 20px;
        }

        form {
            background: white;
            padding: 25px;
            border-radius: 8px;
            max-width: 700px;
            margin: auto;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }

        h3 {
            text-align: center;
            margin-bottom: 20px;
            color: #004080;
        }

        label {
            display: block;
            margin-top: 15px;
            margin-bottom: 5px;
            font-weight: bold;
        }

        input, select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        button {
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #004080;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        button:hover {
            background-color: #003366;
        }

        @media (max-width: 768px) {
            .barra-lateral {
                width: 100%;
                position: relative;
            }

            .conteudo {
                margin: 20px;
            }
        }
    </style>
</head>
<body>
<div class="barra-superior">
    <h2>EduKKap - Cadastro de Aluno</h2>
</div>
<div class="barra-lateral">
    <a href="painel_secretaria_geral.php">🏠 Início</a>
    <a href="matricular_aluno.php">📝 Matricular Aluno</a>
    <a href="lista_alunos_turma.php">👥 Lista de Alunos</a>
</div>
<div class="conteudo">
    <form method="POST">
        <h3>Completar Dados do Aluno</h3>
        <?php echo $mensagem; ?>

        <label>Ano Letivo:</label>
        <select name="ano_letivo" id="ano_letivo" required>
            <option value="">-- Selecione o Ano --</option>
            <?php foreach ($anos_letivos as $ano): ?>
                <option value="<?= $ano ?>"><?= $ano ?></option>
            <?php endforeach; ?>
        </select>

       <label>Turma:</label>
<select name="turma_id" id="turma_id" required>
    <option value="">-- Selecione a Turma --</option>
</select>


       <label>Nome:</label>
<label>Selecionar Aluno:</label>
<select id="aluno_id" name="aluno_id">
    <option value="">-- Selecione o Aluno --</option>
</select>

<input type="hidden" id="aluno_id_hidden" name="aluno_id_hidden">

<label>Nome:</label>
<input type="text" name="nome" required>

        <label>Idade:</label>
        <input type="number" name="idade" required>

        <label>Gênero:</label>
        <select name="genero" required>
            <option value="">-- Selecione --</option>
            <option value="Masculino">Masculino</option>
            <option value="Feminino">Feminino</option>
        </select>

        <label>Número de Ordem:</label>
        <input type="text" name="numero_ordem">

        <label>Naturalidade:</label>
        <input type="text" name="naturalidade">

        <label>Província:</label>
        <input type="text" name="provincia">

        <label>Município:</label>
        <input type="text" name="municipio">

        <label>Nome do Pai:</label>
        <input type="text" name="nome_pai">

        <label>Nome da Mãe:</label>
        <input type="text" name="nome_mae">

        <label>Data de Nascimento:</label>
        <input type="date" name="nascimento">

        <label>BI:</label>
        <input type="text" name="bi">

        <label>Data de Emissão do BI:</label>
        <input type="date" name="bi_emissao_data">

        <label>Local de Emissão do BI:</label>
        <input type="text" name="bi_emissao_local">

        <button type="submit" name="salvar_aluno">Salvar</button>
        <button type="reset">Limpar</button>
    </form>
</div>

<script>
    $(document).ready(function() {

        // Carregar turmas com base no ano letivo selecionado
        $('#ano_letivo').change(function() {
    var ano = $(this).val();
    if (ano !== '') {
        $.ajax({
            url: 'carregar_turmas.php',
            method: 'POST',
            data: { ano_letivo: ano },
            success: function(data) {
                $('#turma_id').html(data);
            }
        });
    }
});


        // Quando a turma for selecionada, carregar os alunos da turma
        $('#turma_id').change(function () {
            var turma_id = $(this).val();
            if (turma_id !== '') {
                $.ajax({
                    url: 'carregar_alunos.php',
                    method: 'POST',
                    data: {turma_id: turma_id},
                    success: function (data) {
                        $('#aluno_id').html(data);
                    }
                });
            }
        });

        // Quando o aluno for selecionado, preencher os campos automaticamente
       // Quando o aluno for selecionado, preencher os campos automaticamente
$('#aluno_id').change(function () {
    var aluno_id = $(this).val();
    if (aluno_id !== '') {
        $.ajax({
            url: 'obter_dados_aluno.php',
            method: 'POST',
            dataType: 'json',
            data: {aluno_id: aluno_id},
            success: function (aluno) {
                $('[name="nome"]').val(aluno.nome);
                $('[name="idade"]').val(aluno.idade);
                $('[name="genero"]').val(aluno.genero);
                $('[name="numero_ordem"]').val(aluno.numero_ordem);
                $('[name="naturalidade"]').val(aluno.naturalidade);
                $('[name="provincia"]').val(aluno.provincia);
                $('[name="municipio"]').val(aluno.municipio);
                $('[name="nome_pai"]').val(aluno.nome_pai);
                $('[name="nome_mae"]').val(aluno.nome_mae);
                $('[name="nascimento"]').val(aluno.nascimento);
                $('[name="bi"]').val(aluno.bi);
                $('[name="bi_emissao_data"]').val(aluno.bi_emissao_data);
                $('[name="bi_emissao_local"]').val(aluno.bi_emissao_local);

                // ⬇️ Adicione esta linha no final do success:
                $('#aluno_id_hidden').val(aluno.id);
            }
        });
    }
});

</script>

</body>
</html>
